local bootup = ui.MediaPlayer()
bootup:setSource('assets/bootup.mp4'):setAutoPlay(true)

function Motec ()

    display.image {
        image = "assets/Motec_Retro.dds",
        pos = vec2(0,0),
        size = vec2(859, 480)
    }
end

function text ()

    display.text {
        text = string.format("%d", car.racePosition),
        pos = vec2(204, 130),
        letter = vec2(50, 60),
        font = "bosch",
        color = rgbm(0,0,0,1),
        width = 46,
        alignment = 1,
        spacing = -18
    }

    display.text {
        text = string.format("%d", car.lapCount),
        pos = vec2(124, 75),
        letter = vec2(50, 60),
        font = "bosch",
        color = rgbm(0,0,0,1),
        width = 46,
        alignment = 1,
        spacing = -18
    }

    display.text {
        text = string.format("%d", car.speedKmh),
        pos = vec2(164, 15),
        letter = vec2(50, 60),
        font = "bosch",
        color = rgbm(0,0,0,1),
        width = 46,
        alignment = 1,
        spacing = -18
    }

    display.text {
        text = string.format("%.1f", ac.getCar().brakeBias * 100 - 50),
        pos = vec2(375, 400),
        letter = vec2(60, 70),
        font = "bosch",
        color = rgbm(0,0,0,1),
        width = 46,
        alignment = 1,
        spacing = -21
    }

    display.text {
        text = string.format("%d", car.rpm),
        pos = vec2(635, 400),
        letter = vec2(60, 70),
        font = "bosch",
        color = rgbm(0,0,0,1),
        width = 46,
        alignment = 1,
        spacing = -21
    }

    display.text {
        text = string.format("%d", car.fuel),
        pos = vec2(134, 390),
        letter = vec2(70, 80),
        font = "bosch",
        color = rgbm(0, 0, 0, 1),
        width = 46,
        alignment = 1,
        spacing = -20
    }

    local color
	if car.performanceMeter > 0 then
    	color = rgbm(1, 0, 0, 1) 
	elseif car.performanceMeter < 0 then
    	color = rgbm(0, 1, 0, 1) 
	else
   	    color = rgbm(0, 0, 0, 1) 
	end

	display.text {
   	 text = string.format("%.2f", car.performanceMeter), 
   	 pos = vec2(155, 300),
   	 letter = vec2(50,60),
   	 font = "bosch",
   	 color = color, 
   	 width = 44,
   	 alignment = 1,
   	 spacing = -20
	}

display.text {
    text = string.format("%02d:%02d.%03d", 
        math.floor(car.previousLapTimeMs / 60000),      
        math.floor((car.previousLapTimeMs % 60000) / 1000), 
        car.previousLapTimeMs % 1000                   
    ),
    pos = vec2(120,185),
    letter = vec2(50, 60),
    font = "bosch",
    color = rgbm(0, 0, 0, 1),
    width = 46,
    alignment = 1,
    spacing = -20
}

  display.text {
    text = string.format("%02d:%02d.%03d", 
        math.floor(car.bestLapTimeMs  / 60000),   
        math.floor((car.bestLapTimeMs % 60000) / 1000), 
        car.bestLapTimeMs % 1000         
    ),
    pos = vec2(130, 245),
    letter = vec2(50, 60),
    font = "bosch",
    color = rgbm(0, 0, 0, 1),
    width = 46,
    alignment = 1,
    spacing = -20
}


    local gearText = tostring(car.gear) 
    if car.gear == -1 then
        gearText = "R"
    end
    if car.gear == 0 then
        gearText = "N"
    end
    display.text {
        text = gearText,
        pos = vec2(640, 122),
        letter = vec2(160, 200),
        font = "bosch",
        color = rgbm(0, 0, 0, 1),
        width = 70,
        alignment = 1,
        spacing = 0
    }
end


function Overrev ()
    if (car.rpm >= 8000) then
        display.image {
          image = 'assets/revwarning.dds',
          pos = vec2(60,70),
        size = vec2(739, 360)
        }
    end
end

function Pitlimiter ()
    if (ac.getCar().isInPitlane) then
        display.image {
          image = 'assets/pitlimiter.dds',
          pos = vec2(60,70),
        size = vec2(739, 360)
        }
    end
end

function Black_Orange ()
    if sim.raceFlagType == ac.FlagType.ReturnToPits then
        display.image {
            image = 'assets/Penalty.dds',
            pos = vec2(0,0),
          size = vec2(859, 150)
          }
    end
end

function Finish ()
    if sim.raceFlagType == ac.FlagType.Finished then
        display.image {
            image = 'assets/Checkeredflag.dds',
            pos = vec2(0,0),
          size = vec2(859, 150)
          }
    end
end

function Caution ()
    if sim.raceFlagType == ac.FlagType.Caution then
        display.image {
            image = 'assets/Caution.dds',
            pos = vec2(0,0),
          size = vec2(859, 150)
          }
    end
end

function Blue ()
    if sim.raceFlagType == ac.FlagType.FasterCar then
        display.image {
            image = 'assets/Yourslow.dds',
            pos = vec2(0,0),
          size = vec2(859, 150)
          }
    end
end


function script.update(dt)
    if (bootup:ended()) then
        Motec()
        text()
        Overrev()
        Pitlimiter()
        Blue()
        Caution()
        Finish()
        Black_Orange()
    else
        ui.drawImage(bootup, vec2(), vec2(859, 480))
    end
end